module GccOptArg
( parseGccOptArg,
  gccGeneration
) where

import Text.ParserCombinators.Parsec
import ParseArgument
import Data

parseGccOptArg :: Parser Option
parseGccOptArg = do xs <- gccoptarg 
                    spaces 
                    ys <- parseArgument
                    spaces
                    return $ Option xs [ys] 


gccoptarg = foldl1 (<|>) $ map try [(string "-MT"),
                                    (string "-o"),
                                    (string "-MF")                          
                                    ]

gccGeneration [ ] = "a.out"
gccGeneration ((Option opt arg) : opts) = if opt == "-o" then (reverse $mytail $ reverse $ (concatMap argFormat arg))
                                          else gccGeneration opts 